/**
 * Sends RPC messages from the slave to the master and waits for a respons.
 * @author Yoel Gluschnaider
 */
var rpcSender = (function () 
{
	
	var me = {};
	
	// a running index of each function call
	var m_id = 0;
	
	// the array of function calls.
	var m_rpcArr = [];
	
	/**
	 * Send RPC call through the comSlave 
	 * @param {String} funcName - the function name.
	 * @param {int} id - the id of this RPC.
	 * @param {Array} args - the function arguments.
	 * 
	 * @author Yoel Gluschnaider 
	 */
	function sendRpc(funcName, id, args) 
	{
		slaveDemux.sendRpcRequest(
		{
			funcName: funcName,
			args: args,
			id: id
		});
	}
	
	/**
	 * Receiving call back to handle the response from the RPC receiver.
	 * @param {Object} messageObj - the message from the receiver.
	 * 
	 * @author Yoel Gluschnaider 
	 */
	me.responseReceived = function(messageObj) 
	{
		if (m_rpcArr[messageObj.id][messageObj.cbName]) 
		{
			m_rpcArr[messageObj.id][messageObj.cbName].apply(window, messageObj.args);
		}
	};

	/**
	 * Invoke an RPC. After the cbFail u can add the method's arguments.
	 * @param {String} funcName - the function name.
	 * @param {Function} cbSuccess - the success call back.
	 * @param {Funciton} cbFail - the failure call back. 
	 * 
	 * @author Yoel Gluschnaider 
	 */
	me.invoke = function (funcName, cbSuccess, cbFail /* , arguments */) 
	{
		// increment and save the id.
		// we do this to avoid race condition due to concurent function invocation.
		var id = ++m_id;

		// save a handle to the success and failure call backs.		
		m_rpcArr[id] = 
		{
			cbSuccess: cbSuccess,
			cbFail: cbFail
		};
		
		// send RPC request.
		sendRpc(funcName, id, [].slice.call(arguments, 3));
		
	};
	
	return me;
	
})();
