/**
 * Slave multiplexer that receives a message from the slaveCom
 * and directs it to the relevant component (RPC sender or Event Handler)
 * 
 * @author Yoel Gluschnaider
 */
var slaveMux = (function () 
{
	
	var me = {};
	
	/**
	 * The call back that handles new messages from the comSlave
	 * and sends them to the relevant handler (eventsHandler or rpcSender).
	 * @param {Object} messageObj - the message from the master.
	 * 
	 * @author Yoel Gluschnaider
	 */
	function receiveCb(messageObj) 
	{
		switch(messageObj.protocol) 
		{
			case protocolTypeEnum.rpc:
				rpcSender.responseReceived(messageObj.rpcResponse);
			break;
			case protocolTypeEnum.event:
				eventsHandler.eventReceived(messageObj.eventName, messageObj.eventData);
			break;
		}
	}
	
	/**
	 * Initialization function, register on the receive message.
	 * 
	 * @author Yoel Gluschnaider
	 */
	function init() 
	{
		comSlave.registerOnReceive(receiveCb);
	}
	
	// init immidiatly.
	init();
	
	return me;
	
})();

